% Section 10.5.1, Actuator Fault Case
% 29/02/2020, Jianglin Lan
close all
clear
clc

% Set up Yalmip & Mosek, this may differ on different computer
% Find installation details in links: 
% https://yalmip.github.io/tutorial/installation/
% https://docs.mosek.com/9.1/toolbox/install-interface.html
addpath(genpath('C:\YALMIP-master'))
addpath('C:\Program Files\Mosek\8\toolbox\r2014a')

% System
Hs1 = 4; Hs2 = 5.1; Hs3 = 5.1;
D1 = 5; D2 = 3; D3 = 3;
Tm1 = 0.35; Tm2 = 0.35; Tm3 = 0.35;
Te1 = 0.1; Te2 = 0.1; Te3 = 0.1;
R1 = 0.05; R2 = 0.05; R3 = 0.05; 
Km1 = 1; Km2 = 1; Km3 = 1; 
Ke1 = 1; Ke2 = 1; Ke3 = 1;
w01 = 314.159; w02 = 314.159; w03 = 314.159; 
% alpha12 = -27.49; alpha13 = -27.49; alpha21 = -23.10; alpha23 = -23.10;  alpha31 = -23.10; alpha32 = -23.10;

A1 = [0 1 0 0;0 -D1/(2*Hs1) w01/(2*Hs1) 0; 0 0 -1/Tm1 Km1/Tm1; 0 -Ke1/(Te1*R1*w01) 0 -1/Te1]; % 4*4
B1 = [0; 0; 0; 1/Te1]; 
C1 = eye(4); 

A2 = [0 1 0 0;0 -D2/(2*Hs2) w02/(2*Hs2) 0; 0 0 -1/Tm2 Km2/Tm2; 0 -Ke2/(Te2*R2*w02) 0 -1/Te2]; % 4*4
B2 = [0; 0; 0; 1/Te2]; 
C2 = eye(4); 

A3 = [0 1 0 0;0 -D3/(2*Hs3) w03/(2*Hs3) 0; 0 0 -1/Tm3 Km3/Tm3; 0 -Ke3/(Te3*R3*w03) 0 -1/Te3]; % 4*4
B3 = [0; 0; 0; 1/Te3];
C3 = eye(4); 

F1 = B1;
F2 = B2;
F3 = B3;

% Design FE observer and FTC controller
H01 = [1 zeros(1,3) -1 zeros(1,3) 0 zeros(1,3);
                        1 zeros(1,3) 0 zeros(1,3) -1 zeros(1,3)]';
  
H02 = [-1 zeros(1,3) 1 zeros(1,3) 0 zeros(1,3);
                         0 zeros(1,3) 1 zeros(1,3) -1 zeros(1,3)]';
  
H03 = [-1 zeros(1,3) 0 zeros(1,3) 1 zeros(1,3);
                        0 zeros(1,3) -1 zeros(1,3) 1 zeros(1,3)]';

[Kx1,Kf1,G1,M1,L1,H1,Kx2,Kf2,G2,M2,L2,H2,Kx3,Kf3,G3,M3,L3,H3] = Observer_controller_design(A1,B1,F1,C1,A2,B2,F2,C2,A3,B3,F3,C3,H01,H02,H03)


% Define global variables to store data
global ff1 ff2 ff3 hat_ff1 hat_ff2 hat_ff3 Int_ts Int_count Int_tmp 
global hat_x11 hat_x12 hat_x13 hat_x14 hat_x21 hat_x22 hat_x23 hat_x24 hat_x31 hat_x32 hat_x33 hat_x34

ff1 = []; ff2 = []; ff3 = []; hat_ff1 = []; hat_ff2 = []; hat_ff3 = [];  Int_ts = []; Int_count = 0; 
Int_tmp = 0; 
hat_x11 = []; hat_x12 = []; hat_x13 = []; hat_x14 = [];
hat_x21 = []; hat_x22 = []; hat_x23 = []; hat_x24 = [];
hat_x31 = []; hat_x32 = []; hat_x33 = []; hat_x34 = [];

% Initial conditon
z0 = 0*ones(15,1);
x0 = [0; 1; 0.5; -1; 0.1; 0.5; -0.1; 0.5; 1; 0.2; 0.5; 0];

para = [z0',x0'];

% Simulation time
t0 = 0;
tf = 4;
tspan = [t0 tf];


% FTC closed-loop system
[Int_tt,Int_yy] = ode45(@(t,xx) FTC_Closed_sys_performance(t,xx,A1,B1,C1,F1,A2,B2,C2,F2,A3,B3,C3,F3,Kx1,Kf1,G1,M1,L1,H1,Kx2,Kf2,G2,M2,L2,H2,Kx3,Kf3,G3,M3,L3,H3), tspan, para);

Int_x11 = Int_yy(:,16);
Int_x12 = Int_yy(:,17);
Int_x13 = Int_yy(:,18);
Int_x14 = Int_yy(:,19);
Int_x21 = Int_yy(:,20);
Int_x22 = Int_yy(:,21);
Int_x23 = Int_yy(:,22);
Int_x24 = Int_yy(:,23);
Int_x31 = Int_yy(:,24);
Int_x32 = Int_yy(:,25);
Int_x33 = Int_yy(:,26);
Int_x34 = Int_yy(:,27);

% Nominal control closed-loop system with Kf = 0
Kf1 = 0*Kf1;
Kf2 = 0*Kf2;
Kf3 = 0*Kf3;
[Intn_tt,Intn_yy] = ode45(@(t,xx) Nominal_Closed_sys_performance(t,xx,A1,B1,C1,F1,A2,B2,C2,F2,A3,B3,C3,F3,Kx1,Kf1,G1,M1,L1,H1,Kx2,Kf2,G2,M2,L2,H2,Kx3,Kf3,G3,M3,L3,H3), tspan, para);

Intn_x11 = Intn_yy(:,16);
Intn_x12 = Intn_yy(:,17);
Intn_x13 = Intn_yy(:,18);
Intn_x14 = Intn_yy(:,19);
Intn_x21 = Intn_yy(:,20);
Intn_x22 = Intn_yy(:,21);
Intn_x23 = Intn_yy(:,22);
Intn_x24 = Intn_yy(:,23);
Intn_x31 = Intn_yy(:,24);
Intn_x32 = Intn_yy(:,25);
Intn_x33 = Intn_yy(:,26);
Intn_x34 = Intn_yy(:,27);

% Draw figures
run('Draw_figures.m');